/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked_programs.cccbridge.peripherals;

import cc.tweaked_programs.cccbridge.blockEntity.ScrollerBlockEntity;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollValueBehaviour;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScrollerBlockPeripheral
implements IPeripheral {
    private final ScrollerBlockEntity scroller;
    private final Level level;
    private final List<IComputerAccess> pcs = new LinkedList<IComputerAccess>();

    public ScrollerBlockPeripheral(ScrollerBlockEntity block_entity, Level level) {
        this.scroller = block_entity;
        this.level = level;
    }

    public void attach(@Nonnull IComputerAccess computer) {
        this.pcs.add(computer);
    }

    public void detach(@Nonnull IComputerAccess computer) {
        this.pcs.removeIf(p -> p.getID() == computer.getID());
    }

    public void newValue(int value) {
        for (IComputerAccess pc : this.pcs) {
            pc.queueEvent("scroller_changed", new Object[]{pc.getAttachmentName(), (double)(value / 10)});
        }
    }

    @LuaFunction
    public final boolean isLocked() {
        return (Boolean)this.level.m_8055_(this.scroller.m_58899_()).m_61143_((Property)BlockStateProperties.f_61444_);
    }

    @LuaFunction
    public final void setLock(boolean state) {
        this.scroller.setLock(state);
    }

    @LuaFunction
    public final double getValue() {
        ScrollValueBehaviour scrollValueBehaviour = this.scroller.getBehaviour();
        if (scrollValueBehaviour == null) {
            return 0.0;
        }
        return (double)scrollValueBehaviour.getValue() / 10.0;
    }

    @LuaFunction
    public final void setValue(double value) {
        ScrollValueBehaviour scrollValueBehaviour = this.scroller.getBehaviour();
        if (scrollValueBehaviour == null) {
            return;
        }
        if (value > 15.0) {
            value = 15.0;
        } else if (value < -15.0) {
            value = -15.0;
        }
        scrollValueBehaviour.setValue((int)(value * 10.0));
        this.scroller.playTickSound();
    }

    @NotNull
    public String getType() {
        return "scroller";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable IPeripheral other) {
        if (this == other) return true;
        if (!(other instanceof ScrollerBlockPeripheral)) return false;
        ScrollerBlockPeripheral s = (ScrollerBlockPeripheral)other;
        if (s.scroller != this.scroller) return false;
        return true;
    }
}

